/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.common.book.Book;

public class GuiButtonBookMarkRead
extends GuiButtonBook {
    private final Book book;

    public GuiButtonBookMarkRead(GuiBook parent, int x, int y) {
        super(parent, x, y, 308, 31, 11, 11, Button::m_5691_, GuiButtonBookMarkRead.getTooltip(parent.book));
        this.book = parent.book;
    }

    @Override
    public void m_6303_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        int px = this.f_93620_ + 1;
        int py = (int)((double)this.f_93621_ + 0.5);
        GuiBook.drawFromTexture(ms, this.book, this.f_93620_, this.f_93621_, 285, 160, 13, 10);
        GuiBook.drawFromTexture(ms, this.book, px, py, this.u, this.v, this.f_93618_, this.f_93619_);
        if (this.m_198029_()) {
            GuiBook.drawFromTexture(ms, this.book, px, py, this.u + 11, this.v, this.f_93618_, this.f_93619_);
            this.parent.setTooltip(this.getTooltip());
        }
        this.parent.getMinecraft().f_91062_.m_92750_(ms, "+", (float)px - 0.5f, (float)py - 0.2f, 65281);
    }

    public void m_5691_() {
        for (BookEntry entry : this.book.getContents().entries.values()) {
            if (GuiButtonBookMarkRead.isMainPage(this.book)) {
                this.markEntry(entry);
                continue;
            }
            this.markCategoryAsRead(entry, entry.getCategory(), this.book.getContents().entries.size());
        }
    }

    private void markCategoryAsRead(BookEntry entry, BookCategory category, int maxRecursion) {
        if (category.getName().equals(this.book.getContents().getCurrentGui().m_96636_())) {
            this.markEntry(entry);
        } else if (!category.isRootCategory() && maxRecursion > 0) {
            this.markCategoryAsRead(entry, entry.getCategory().getParentCategory(), maxRecursion - 1);
        }
    }

    private void markEntry(BookEntry entry) {
        boolean dirty = false;
        ResourceLocation key = entry.getId();
        if (!entry.isLocked() && entry.getReadState().equals((Object)EntryDisplayState.UNREAD)) {
            PersistentData.BookData data = PersistentData.data.getBookData(this.book);
            if (!data.viewedEntries.contains(key)) {
                data.viewedEntries.add(key);
                dirty = true;
                entry.markReadStateDirty();
            }
        }
        if (dirty) {
            PersistentData.save();
        }
    }

    private static Component getTooltip(Book book) {
        String text = GuiButtonBookMarkRead.isMainPage(book) ? "patchouli.gui.lexicon.button.mark_all_read" : "patchouli.gui.lexicon.button.mark_category_read";
        return new TranslatableComponent(text);
    }

    private static boolean isMainPage(Book book) {
        return !book.getContents().currentGui.canSeeBackButton();
    }
}

